//
//  OPLogin.h
//  OnePasswordiOS
//
//  Created by Roustem Karimov on 12-03-30.
//  Copyright (c) 2012 AgileBits. All rights reserved.
//

#import "OPItem.h"
#import "OPLoginField.h"
#import "OPLoginFieldList.h"

@interface OPLogin : OPItem

//@property (nonatomic, retain) NSSet * fields;
//@property (nonatomic, retain) NSString * shouldAutoFill;

@property (nonatomic) NSString * autosubmit;
@property (nonatomic, readonly, getter = isDefaultAutosubmit) BOOL defaultAutosubmit;
@property (nonatomic, readonly, getter = isAlwaysAutosubmit) BOOL alwaysAutosubmit;
@property (nonatomic, readonly, getter = isNeverAutosubmit) BOOL neverAutosubmit;
@property (nonatomic, readonly) NSString * localizedAutosubmitDescription;

@property (nonatomic, readonly) OPLoginFieldList *loginFields;

@property (nonatomic, strong) NSString * htmlName;
@property (nonatomic, strong) NSString * htmlMethod;
@property (nonatomic, strong) NSString * htmlID;
@property (nonatomic, strong) NSString * htmlAction;


+ (id)fieldSectionsAsLoginFields:(NSArray *)fieldSections;
+ (NSString *)localizedAutosubmitDescriptionForValue:(NSString *)value;

- (NSDictionary *)brainDictionary;
+ (OPLogin *)loginFromLegacyJSELoginJSON:(NSDictionary *)json withProfile:(id<OPGenericProfile>)profile;
+ (OPLogin *)loginFromBrainDictionary:(NSDictionary *)brainDictionary withProfile:(id<OPGenericProfile>)profile;

@end
